SET SQL_SAFE_UPDATES=0;
SET @dtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='CREATE_ENQUIRY_PARENT_RECIPIENTS');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
        T2.id AS ID,
        T1.code AS ENQUIRY_CODE,
        T1.firstName AS STUDENT_FIRSTNAME,
        T1.lastName AS STUDENT_LASTNAME,
        T2.fatherFirstName AS PARENT_FIRSTNAME,
        T2.fatherLastName AS PARENT_LASTNAME,       
        T2.fatherEmailId AS EMAIL_ID,
        T2.fatherPhoneNo AS MOBILE_NO,
        T2.fatherPhoneCountryCode AS MOBILE_CODE,
        T4.academyName AS ACADEMY_NAME,
        T4.displayName AS ACADEMY_NAME_LOCATION,
        T6.primaryeEmailId AS ACADEMY_LOCATION_EMAIL_ID,
        T6.websiteURL AS ACADEMY_LOCATION_URL,
        CONCAT(T6.phoneCountryCode,'-',T6.phoneNo) AS ACADEMY_LOCATION_PHONE_NO,
        (Case when T4.logoUrl is null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', 'emailer/images/logo_default_image.png') 
        when T4.logoUrl is null and org.orgUrl is null then 'https://www.serosoft.com/mailer/academiaerp_logo_red.png'
        else CONCAT(org.orgUrl, '/', T4.logoUrl)end) as LOGO_URL,
        (Case when T4.headerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.headerUrl) 
        else NULL end) as HEADER_URL,
            (Case when T4.footerUrl is not null and org.orgUrl IS NOT NULL then CONCAT(org.orgUrl, '/', T4.footerUrl) 
        else NULL end) as FOOTER_URL     
    FROM
        enquiry T1
            LEFT JOIN
        enq_student_details T2 ON T2.enquiryId = T1.id
            LEFT JOIN
        academy_location T4 ON T4.id = T1.academyLocationId
            LEFT JOIN
        academy_location_addresses T5 ON T5.academyLocationId = T4.id
            LEFT JOIN
        address T6 ON T6.id = T5.addressId AND T6.addressTypeId = 10
            LEFT JOIN
        organizations org on org.id = 1      
    WHERE
        T1.id IN (namedParams)",`jsonString` = '{
    "id": 1,
    "searchResultViewColumns": [
        {
            "id": 1,
            "value": "code",
            "resultKey": "ENQUIRY_CODE",
            "displayCode": "",
            "displayOrder": 0
        },
        {
            "id": 2,
            "value": "parentFirstName",
            "resultKey": "PARENT_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 1
        },
        {
            "id": 3,
            "value": "parentLastName",
            "resultKey": "PARENT_LASTNAME",
            "displayCode": "",
            "displayOrder": 2
        },
        {
            "id": 4,
            "value": "studentFirstName",
            "resultKey": "STUDENT_FIRSTNAME",
            "displayCode": "",
            "displayOrder": 3
        },
        {
            "id": 5,
            "value": "studentLastName",
            "resultKey": "STUDENT_LASTNAME",
            "displayCode": "",
            "displayOrder": 4
        },
        {
            "id": 6,
            "value": "displayName",
            "resultKey": "ACADEMY_NAME_LOCATION",
            "displayCode": "",
            "displayOrder": 5
        },       
        {
            "id": 7,
            "value": "academyLocationEmailId",
            "resultKey": "ACADEMY_LOCATION_EMAIL_ID",
            "displayCode": "",
            "displayOrder": 6
        },
        {
            "id": 8,
            "value": "academyLocationURL",
            "resultKey": "ACADEMY_LOCATION_URL",
            "displayCode": "",
            "displayOrder": 7
        },
        {
            "id": 9,
            "value": "academyName",
            "resultKey": "ACADEMY_NAME",
            "displayCode": "",
            "displayOrder": 8
        },
        {
            "id": 10,
            "value": "academyLocationPhoneNo",
            "resultKey": "ACADEMY_LOCATION_PHONE_NO",
            "displayCode": "",
            "displayOrder": 9
        }
    ]
}' WHERE `dataProviderId` = @dtproviderId;
SET SQL_SAFE_UPDATES=1;